package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface HorizontalPodAutoscalerListFluent<A extends HorizontalPodAutoscalerListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(HorizontalPodAutoscaler... items);
    public A removeFromItems(HorizontalPodAutoscaler... items);
    public List<HorizontalPodAutoscaler> getItems();
    public A withItems(List<HorizontalPodAutoscaler> items);
    public A withItems(HorizontalPodAutoscaler... items);
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItem();
    public HorizontalPodAutoscalerListFluent.ItemsNested<A> addNewItemLike(HorizontalPodAutoscaler item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public HorizontalPodAutoscalerListFluent.MetadataNested<A> withNewMetadata();
    public HorizontalPodAutoscalerListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public HorizontalPodAutoscalerListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,HorizontalPodAutoscalerFluent<HorizontalPodAutoscalerListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<HorizontalPodAutoscalerListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
