package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.LabelSelector;
import javax.validation.Valid;
import java.lang.String;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluent;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;

public interface PetSetSpecFluent<A extends PetSetSpecFluent<A>> extends Fluent<A>{


    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public LabelSelector getSelector();
    public A withSelector(LabelSelector selector);
    public PetSetSpecFluent.SelectorNested<A> withNewSelector();
    public PetSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public PetSetSpecFluent.SelectorNested<A> editSelector();
    public String getServiceName();
    public A withServiceName(String serviceName);
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public PetSetSpecFluent.TemplateNested<A> withNewTemplate();
    public PetSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public PetSetSpecFluent.TemplateNested<A> editTemplate();
    public A addToVolumeClaimTemplates(PersistentVolumeClaim... items);
    public A removeFromVolumeClaimTemplates(PersistentVolumeClaim... items);
    public List<PersistentVolumeClaim> getVolumeClaimTemplates();
    public A withVolumeClaimTemplates(List<PersistentVolumeClaim> volumeClaimTemplates);
    public A withVolumeClaimTemplates(PersistentVolumeClaim... volumeClaimTemplates);
    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate();
    public PetSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(PersistentVolumeClaim item);

    public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<PetSetSpecFluent.SelectorNested<N>>{

        
    public N endSelector();    public N and();
}
    public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<PetSetSpecFluent.TemplateNested<N>>{

        
    public N endTemplate();    public N and();
}
    public interface VolumeClaimTemplatesNested<N> extends Nested<N>,PersistentVolumeClaimFluent<PetSetSpecFluent.VolumeClaimTemplatesNested<N>>{

        
    public N endVolumeClaimTemplate();    public N and();
}


}
