package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.NotNull;
import java.lang.Object;

public class SubresourceReferenceFluentImpl<A extends SubresourceReferenceFluent<A>> extends BaseFluent<A> implements SubresourceReferenceFluent<A>{

    private String apiVersion;
    private String kind;
    private String name;
    private String subresource;

    public SubresourceReferenceFluentImpl(){
    }
    public SubresourceReferenceFluentImpl(SubresourceReference instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.withSubresource(instance.getSubresource()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public String getSubresource(){
            return this.subresource;
    }

    public A withSubresource(String subresource){
            this.subresource=subresource; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            SubresourceReferenceFluentImpl that = (SubresourceReferenceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (subresource != null ? !subresource.equals(that.subresource) :that.subresource != null) return false;
            return true;
    }




}
