package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public interface ThirdPartyResourceFluent<A extends ThirdPartyResourceFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getDescription();
    public A withDescription(String description);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadata();
    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ThirdPartyResourceFluent.MetadataNested<A> editMetadata();
    public A addToVersions(APIVersion... items);
    public A removeFromVersions(APIVersion... items);
    public List<APIVersion> getVersions();
    public A withVersions(List<APIVersion> versions);
    public A withVersions(APIVersion... versions);
    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersion();
    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersionLike(APIVersion item);
    public A addNewVersion(String name);

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ThirdPartyResourceFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface VersionsNested<N> extends Nested<N>,APIVersionFluent<ThirdPartyResourceFluent.VersionsNested<N>>{

        
    public N and();    public N endVersion();
}


}
