package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.util.List;
import java.util.ArrayList;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;

public class ThirdPartyResourceFluentImpl<A extends ThirdPartyResourceFluent<A>> extends BaseFluent<A> implements ThirdPartyResourceFluent<A>{

    private String apiVersion;
    private String description;
    private String kind;
    private VisitableBuilder<? extends ObjectMeta,?> metadata;
    private List<VisitableBuilder<? extends APIVersion,?>> versions =  new ArrayList<VisitableBuilder<? extends APIVersion,?>>();

    public ThirdPartyResourceFluentImpl(){
    }
    public ThirdPartyResourceFluentImpl(ThirdPartyResource instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withDescription(instance.getDescription()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.withVersions(instance.getVersions()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getDescription(){
            return this.description;
    }

    public A withDescription(String description){
            this.description=description; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ObjectMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ObjectMeta metadata){
            if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ThirdPartyResourceFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item){
            return new MetadataNestedImpl(item);
    }

    public ThirdPartyResourceFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public A addToVersions(APIVersion... items){
            for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.add(builder);this.versions.add(builder);} return (A)this;
    }

    public A removeFromVersions(APIVersion... items){
            for (APIVersion item : items) {APIVersionBuilder builder = new APIVersionBuilder(item);_visitables.remove(builder);this.versions.remove(builder);} return (A)this;
    }

    public List<APIVersion> getVersions(){
            return build(versions);
    }

    public A withVersions(List<APIVersion> versions){
            this.versions.clear();
            if (versions != null) {for (APIVersion item : versions){this.addToVersions(item);}} return (A) this;
    }

    public A withVersions(APIVersion... versions){
            this.versions.clear(); if (versions != null) {for (APIVersion item :versions){ this.addToVersions(item);}} return (A) this;
    }

    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersion(){
            return new VersionsNestedImpl();
    }

    public ThirdPartyResourceFluent.VersionsNested<A> addNewVersionLike(APIVersion item){
            return new VersionsNestedImpl(item);
    }

    public A addNewVersion(String name){
            return (A)addToVersions(new APIVersion(name));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ThirdPartyResourceFluentImpl that = (ThirdPartyResourceFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (description != null ? !description.equals(that.description) :that.description != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
            return true;
    }


    public class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<ThirdPartyResourceFluent.MetadataNested<N>> implements ThirdPartyResourceFluent.MetadataNested<N>,Nested<N>{

            private final ObjectMetaBuilder builder;
    
            MetadataNestedImpl(ObjectMeta item){
                    this.builder = new ObjectMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ObjectMetaBuilder(this);
            }
    
    public N and(){
            return (N) ThirdPartyResourceFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}
    public class VersionsNestedImpl<N> extends APIVersionFluentImpl<ThirdPartyResourceFluent.VersionsNested<N>> implements ThirdPartyResourceFluent.VersionsNested<N>,Nested<N>{

            private final APIVersionBuilder builder;
    
            VersionsNestedImpl(APIVersion item){
                    this.builder = new APIVersionBuilder(this, item);
            }
            VersionsNestedImpl(){
                    this.builder = new APIVersionBuilder(this);
            }
    
    public N and(){
            return (N) ThirdPartyResourceFluentImpl.this.addToVersions(builder.build());
    }
    public N endVersion(){
            return and();
    }

}


}
