package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ComponentStatusFluent<A extends ComponentStatusFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToConditions(ComponentCondition... items);
    public A removeFromConditions(ComponentCondition... items);
    public List<ComponentCondition> getConditions();
    public A withConditions(List<ComponentCondition> conditions);
    public A withConditions(ComponentCondition... conditions);
    public ComponentStatusFluent.ConditionsNested<A> addNewCondition();
    public ComponentStatusFluent.ConditionsNested<A> addNewConditionLike(ComponentCondition item);
    public A addNewCondition(String error,String message,String status,String type);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ComponentStatusFluent.MetadataNested<A> withNewMetadata();
    public ComponentStatusFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ComponentStatusFluent.MetadataNested<A> editMetadata();

    public interface ConditionsNested<N> extends Nested<N>,ComponentConditionFluent<ComponentStatusFluent.ConditionsNested<N>>{

        
    public N endCondition();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<ComponentStatusFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
