package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Object;

public class HTTPHeaderFluentImpl<A extends HTTPHeaderFluent<A>> extends BaseFluent<A> implements HTTPHeaderFluent<A>{

    private String name;
    private String value;

    public HTTPHeaderFluentImpl(){
    }
    public HTTPHeaderFluentImpl(HTTPHeader instance){
            this.withName(instance.getName()); 
            this.withValue(instance.getValue()); 
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public String getValue(){
            return this.value;
    }

    public A withValue(String value){
            this.value=value; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            HTTPHeaderFluentImpl that = (HTTPHeaderFluentImpl) o;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (value != null ? !value.equals(that.value) :that.value != null) return false;
            return true;
    }




}
