package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NodeListFluent<A extends NodeListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Node... items);
    public A removeFromItems(Node... items);
    public List<Node> getItems();
    public A withItems(List<Node> items);
    public A withItems(Node... items);
    public NodeListFluent.ItemsNested<A> addNewItem();
    public NodeListFluent.ItemsNested<A> addNewItemLike(Node item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public NodeListFluent.MetadataNested<A> withNewMetadata();
    public NodeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public NodeListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,NodeFluent<NodeListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<NodeListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
