package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.Map;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.Integer;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PersistentVolumeSpecFluent<A extends PersistentVolumeSpecFluent<A>> extends Fluent<A>{


    public A addToAccessModes(String... items);
    public A removeFromAccessModes(String... items);
    public List<String> getAccessModes();
    public A withAccessModes(List<String> accessModes);
    public A withAccessModes(String... accessModes);
    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore();
    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore);
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore();
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item);
    public PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore();
    public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID);
    public AzureFileVolumeSource getAzureFile();
    public A withAzureFile(AzureFileVolumeSource azureFile);
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFile();
    public PersistentVolumeSpecFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item);
    public PersistentVolumeSpecFluent.AzureFileNested<A> editAzureFile();
    public A withNewAzureFile(Boolean readOnly,String secretName,String shareName);
    public A addToCapacity(String key,Quantity value);
    public A addToCapacity(Map<String,Quantity> map);
    public A removeFromCapacity(String key);
    public A removeFromCapacity(Map<String,Quantity> map);
    public Map<String,Quantity> getCapacity();
    public A withCapacity(Map<String,Quantity> capacity);
    public CephFSVolumeSource getCephfs();
    public A withCephfs(CephFSVolumeSource cephfs);
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfs();
    public PersistentVolumeSpecFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item);
    public PersistentVolumeSpecFluent.CephfsNested<A> editCephfs();
    public CinderVolumeSource getCinder();
    public A withCinder(CinderVolumeSource cinder);
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinder();
    public PersistentVolumeSpecFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item);
    public PersistentVolumeSpecFluent.CinderNested<A> editCinder();
    public A withNewCinder(String fsType,Boolean readOnly,String volumeID);
    public ObjectReference getClaimRef();
    public A withClaimRef(ObjectReference claimRef);
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRef();
    public PersistentVolumeSpecFluent.ClaimRefNested<A> withNewClaimRefLike(ObjectReference item);
    public PersistentVolumeSpecFluent.ClaimRefNested<A> editClaimRef();
    public FCVolumeSource getFc();
    public A withFc(FCVolumeSource fc);
    public PersistentVolumeSpecFluent.FcNested<A> withNewFc();
    public PersistentVolumeSpecFluent.FcNested<A> withNewFcLike(FCVolumeSource item);
    public PersistentVolumeSpecFluent.FcNested<A> editFc();
    public FlexVolumeSource getFlexVolume();
    public A withFlexVolume(FlexVolumeSource flexVolume);
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolume();
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item);
    public PersistentVolumeSpecFluent.FlexVolumeNested<A> editFlexVolume();
    public FlockerVolumeSource getFlocker();
    public A withFlocker(FlockerVolumeSource flocker);
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlocker();
    public PersistentVolumeSpecFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item);
    public PersistentVolumeSpecFluent.FlockerNested<A> editFlocker();
    public A withNewFlocker(String datasetName);
    public GCEPersistentDiskVolumeSource getGcePersistentDisk();
    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk);
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk();
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item);
    public PersistentVolumeSpecFluent.GcePersistentDiskNested<A> editGcePersistentDisk();
    public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly);
    public GlusterfsVolumeSource getGlusterfs();
    public A withGlusterfs(GlusterfsVolumeSource glusterfs);
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfs();
    public PersistentVolumeSpecFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item);
    public PersistentVolumeSpecFluent.GlusterfsNested<A> editGlusterfs();
    public A withNewGlusterfs(String endpoints,String path,Boolean readOnly);
    public HostPathVolumeSource getHostPath();
    public A withHostPath(HostPathVolumeSource hostPath);
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPath();
    public PersistentVolumeSpecFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item);
    public PersistentVolumeSpecFluent.HostPathNested<A> editHostPath();
    public A withNewHostPath(String path);
    public ISCSIVolumeSource getIscsi();
    public A withIscsi(ISCSIVolumeSource iscsi);
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsi();
    public PersistentVolumeSpecFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item);
    public PersistentVolumeSpecFluent.IscsiNested<A> editIscsi();
    public NFSVolumeSource getNfs();
    public A withNfs(NFSVolumeSource nfs);
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfs();
    public PersistentVolumeSpecFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item);
    public PersistentVolumeSpecFluent.NfsNested<A> editNfs();
    public A withNewNfs(String path,Boolean readOnly,String server);
    public String getPersistentVolumeReclaimPolicy();
    public A withPersistentVolumeReclaimPolicy(String persistentVolumeReclaimPolicy);
    public RBDVolumeSource getRbd();
    public A withRbd(RBDVolumeSource rbd);
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbd();
    public PersistentVolumeSpecFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item);
    public PersistentVolumeSpecFluent.RbdNested<A> editRbd();
    public VsphereVirtualDiskVolumeSource getVsphereVolume();
    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume);
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolume();
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item);
    public PersistentVolumeSpecFluent.VsphereVolumeNested<A> editVsphereVolume();
    public A withNewVsphereVolume(String fsType,String volumePath);

    public interface AwsElasticBlockStoreNested<N> extends Nested<N>,AWSElasticBlockStoreVolumeSourceFluent<PersistentVolumeSpecFluent.AwsElasticBlockStoreNested<N>>{

        
    public N endAwsElasticBlockStore();    public N and();
}
    public interface AzureFileNested<N> extends Nested<N>,AzureFileVolumeSourceFluent<PersistentVolumeSpecFluent.AzureFileNested<N>>{

        
    public N endAzureFile();    public N and();
}
    public interface CephfsNested<N> extends Nested<N>,CephFSVolumeSourceFluent<PersistentVolumeSpecFluent.CephfsNested<N>>{

        
    public N endCephfs();    public N and();
}
    public interface CinderNested<N> extends Nested<N>,CinderVolumeSourceFluent<PersistentVolumeSpecFluent.CinderNested<N>>{

        
    public N and();    public N endCinder();
}
    public interface ClaimRefNested<N> extends Nested<N>,ObjectReferenceFluent<PersistentVolumeSpecFluent.ClaimRefNested<N>>{

        
    public N and();    public N endClaimRef();
}
    public interface FcNested<N> extends Nested<N>,FCVolumeSourceFluent<PersistentVolumeSpecFluent.FcNested<N>>{

        
    public N and();    public N endFc();
}
    public interface FlexVolumeNested<N> extends Nested<N>,FlexVolumeSourceFluent<PersistentVolumeSpecFluent.FlexVolumeNested<N>>{

        
    public N and();    public N endFlexVolume();
}
    public interface FlockerNested<N> extends Nested<N>,FlockerVolumeSourceFluent<PersistentVolumeSpecFluent.FlockerNested<N>>{

        
    public N and();    public N endFlocker();
}
    public interface GcePersistentDiskNested<N> extends Nested<N>,GCEPersistentDiskVolumeSourceFluent<PersistentVolumeSpecFluent.GcePersistentDiskNested<N>>{

        
    public N endGcePersistentDisk();    public N and();
}
    public interface GlusterfsNested<N> extends Nested<N>,GlusterfsVolumeSourceFluent<PersistentVolumeSpecFluent.GlusterfsNested<N>>{

        
    public N and();    public N endGlusterfs();
}
    public interface HostPathNested<N> extends Nested<N>,HostPathVolumeSourceFluent<PersistentVolumeSpecFluent.HostPathNested<N>>{

        
    public N and();    public N endHostPath();
}
    public interface IscsiNested<N> extends Nested<N>,ISCSIVolumeSourceFluent<PersistentVolumeSpecFluent.IscsiNested<N>>{

        
    public N and();    public N endIscsi();
}
    public interface NfsNested<N> extends Nested<N>,NFSVolumeSourceFluent<PersistentVolumeSpecFluent.NfsNested<N>>{

        
    public N endNfs();    public N and();
}
    public interface RbdNested<N> extends Nested<N>,RBDVolumeSourceFluent<PersistentVolumeSpecFluent.RbdNested<N>>{

        
    public N and();    public N endRbd();
}
    public interface VsphereVolumeNested<N> extends Nested<N>,VsphereVirtualDiskVolumeSourceFluent<PersistentVolumeSpecFluent.VsphereVolumeNested<N>>{

        
    public N endVsphereVolume();    public N and();
}


}
