package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import io.fabric8.kubernetes.api.builder.Nested;

public interface PodTemplateSpecFluent<A extends PodTemplateSpecFluent<A>> extends Fluent<A>{


    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public PodTemplateSpecFluent.MetadataNested<A> withNewMetadata();
    public PodTemplateSpecFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public PodTemplateSpecFluent.MetadataNested<A> editMetadata();
    public PodSpec getSpec();
    public A withSpec(PodSpec spec);
    public PodTemplateSpecFluent.SpecNested<A> withNewSpec();
    public PodTemplateSpecFluent.SpecNested<A> withNewSpecLike(PodSpec item);
    public PodTemplateSpecFluent.SpecNested<A> editSpec();

    public interface MetadataNested<N> extends Nested<N>,ObjectMetaFluent<PodTemplateSpecFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends Nested<N>,PodSpecFluent<PodTemplateSpecFluent.SpecNested<N>>{

        
    public N endSpec();    public N and();
}


}
