package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import javax.validation.Valid;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;

public interface CustomBuildStrategyFluent<A extends CustomBuildStrategyFluent<A>> extends Fluent<A>{


    public String getBuildAPIVersion();
    public A withBuildAPIVersion(String buildAPIVersion);
    public A addToEnv(EnvVar... items);
    public A removeFromEnv(EnvVar... items);
    public List<EnvVar> getEnv();
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public CustomBuildStrategyFluent.EnvNested<A> addNewEnv();
    public CustomBuildStrategyFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public Boolean isExposeDockerSocket();
    public A withExposeDockerSocket(Boolean exposeDockerSocket);
    public Boolean isForcePull();
    public A withForcePull(Boolean forcePull);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public CustomBuildStrategyFluent.FromNested<A> withNewFrom();
    public CustomBuildStrategyFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public CustomBuildStrategyFluent.FromNested<A> editFrom();
    public LocalObjectReference getPullSecret();
    public A withPullSecret(LocalObjectReference pullSecret);
    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecret();
    public CustomBuildStrategyFluent.PullSecretNested<A> withNewPullSecretLike(LocalObjectReference item);
    public CustomBuildStrategyFluent.PullSecretNested<A> editPullSecret();
    public A withNewPullSecret(String name);
    public A addToSecrets(SecretSpec... items);
    public A removeFromSecrets(SecretSpec... items);
    public List<SecretSpec> getSecrets();
    public A withSecrets(List<SecretSpec> secrets);
    public A withSecrets(SecretSpec... secrets);
    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecret();
    public CustomBuildStrategyFluent.SecretsNested<A> addNewSecretLike(SecretSpec item);

    public interface EnvNested<N> extends Nested<N>,EnvVarFluent<CustomBuildStrategyFluent.EnvNested<N>>{

        
    public N endEnv();    public N and();
}
    public interface FromNested<N> extends Nested<N>,ObjectReferenceFluent<CustomBuildStrategyFluent.FromNested<N>>{

        
    public N endFrom();    public N and();
}
    public interface PullSecretNested<N> extends Nested<N>,LocalObjectReferenceFluent<CustomBuildStrategyFluent.PullSecretNested<N>>{

        
    public N and();    public N endPullSecret();
}
    public interface SecretsNested<N> extends Nested<N>,SecretSpecFluent<CustomBuildStrategyFluent.SecretsNested<N>>{

        
    public N and();    public N endSecret();
}


}
