/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.ClusterRoleBindingList;
import io.fabric8.openshift.api.model.ClusterRoleBindingListFluent;
import io.fabric8.openshift.api.model.ClusterRoleBindingListFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ClusterRoleBindingListBuilder
extends ClusterRoleBindingListFluentImpl<ClusterRoleBindingListBuilder>
implements VisitableBuilder<ClusterRoleBindingList, ClusterRoleBindingListBuilder> {
    ClusterRoleBindingListFluent<?> fluent;
    Boolean validationEnabled;

    public ClusterRoleBindingListBuilder() {
        this(true);
    }

    public ClusterRoleBindingListBuilder(Boolean validationEnabled) {
        this(new ClusterRoleBindingList(), validationEnabled);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ClusterRoleBindingList(), validationEnabled);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent, ClusterRoleBindingList instance) {
        this(fluent, instance, true);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingListFluent<?> fluent, ClusterRoleBindingList instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withApiVersion(instance.getApiVersion());
        fluent.withItems(instance.getItems());
        fluent.withKind(instance.getKind());
        fluent.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingList instance) {
        this(instance, (Boolean)true);
    }

    public ClusterRoleBindingListBuilder(ClusterRoleBindingList instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ClusterRoleBindingList build() {
        ClusterRoleBindingList buildable = new ClusterRoleBindingList(this.fluent.getApiVersion(), this.fluent.getItems(), this.fluent.getKind(), this.fluent.getMetadata());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ClusterRoleBindingListBuilder that = (ClusterRoleBindingListBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

