package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.Boolean;
import javax.validation.constraints.NotNull;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class ClusterFluentImpl<A extends ClusterFluent<A>> extends BaseFluent<A> implements ClusterFluent<A>{

    private String apiVersion;
    private String certificateAuthority;
    private String certificateAuthorityData;
    private List<VisitableBuilder<? extends NamedExtension,?>> extensions =  new ArrayList<VisitableBuilder<? extends NamedExtension,?>>();
    private Boolean insecureSkipTlsVerify;
    private String server;

    public ClusterFluentImpl(){
    }
    public ClusterFluentImpl(Cluster instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withCertificateAuthority(instance.getCertificateAuthority()); 
            this.withCertificateAuthorityData(instance.getCertificateAuthorityData()); 
            this.withExtensions(instance.getExtensions()); 
            this.withInsecureSkipTlsVerify(instance.getInsecureSkipTlsVerify()); 
            this.withServer(instance.getServer()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public String getCertificateAuthority(){
            return this.certificateAuthority;
    }

    public A withCertificateAuthority(String certificateAuthority){
            this.certificateAuthority=certificateAuthority; return (A) this;
    }

    public String getCertificateAuthorityData(){
            return this.certificateAuthorityData;
    }

    public A withCertificateAuthorityData(String certificateAuthorityData){
            this.certificateAuthorityData=certificateAuthorityData; return (A) this;
    }

    public A addToExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.add(builder);this.extensions.add(builder);} return (A)this;
    }

    public A removeFromExtensions(NamedExtension... items){
            for (NamedExtension item : items) {NamedExtensionBuilder builder = new NamedExtensionBuilder(item);_visitables.remove(builder);this.extensions.remove(builder);} return (A)this;
    }

    public List<NamedExtension> getExtensions(){
            return build(extensions);
    }

    public A withExtensions(List<NamedExtension> extensions){
            this.extensions.clear();
            if (extensions != null) {for (NamedExtension item : extensions){this.addToExtensions(item);}} return (A) this;
    }

    public A withExtensions(NamedExtension... extensions){
            this.extensions.clear(); if (extensions != null) {for (NamedExtension item :extensions){ this.addToExtensions(item);}} return (A) this;
    }

    public ClusterFluent.ExtensionsNested<A> addNewExtension(){
            return new ExtensionsNestedImpl();
    }

    public ClusterFluent.ExtensionsNested<A> addNewExtensionLike(NamedExtension item){
            return new ExtensionsNestedImpl(item);
    }

    public Boolean isInsecureSkipTlsVerify(){
            return this.insecureSkipTlsVerify;
    }

    public A withInsecureSkipTlsVerify(Boolean insecureSkipTlsVerify){
            this.insecureSkipTlsVerify=insecureSkipTlsVerify; return (A) this;
    }

    public String getServer(){
            return this.server;
    }

    public A withServer(String server){
            this.server=server; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ClusterFluentImpl that = (ClusterFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (certificateAuthority != null ? !certificateAuthority.equals(that.certificateAuthority) :that.certificateAuthority != null) return false;
            if (certificateAuthorityData != null ? !certificateAuthorityData.equals(that.certificateAuthorityData) :that.certificateAuthorityData != null) return false;
            if (extensions != null ? !extensions.equals(that.extensions) :that.extensions != null) return false;
            if (insecureSkipTlsVerify != null ? !insecureSkipTlsVerify.equals(that.insecureSkipTlsVerify) :that.insecureSkipTlsVerify != null) return false;
            if (server != null ? !server.equals(that.server) :that.server != null) return false;
            return true;
    }


    public class ExtensionsNestedImpl<N> extends NamedExtensionFluentImpl<ClusterFluent.ExtensionsNested<N>> implements ClusterFluent.ExtensionsNested<N>,Nested<N>{

            private final NamedExtensionBuilder builder;
    
            ExtensionsNestedImpl(){
                    this.builder = new NamedExtensionBuilder(this);
            }
            ExtensionsNestedImpl(NamedExtension item){
                    this.builder = new NamedExtensionBuilder(this, item);
            }
    
    public N and(){
            return (N) ClusterFluentImpl.this.addToExtensions(builder.build());
    }
    public N endExtension(){
            return and();
    }

}


}
