package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface ConfigMapVolumeSourceFluent<A extends ConfigMapVolumeSourceFluent<A>> extends Fluent<A>{


    public A addToItems(KeyToPath... items);
    public A removeFromItems(KeyToPath... items);
    public List<KeyToPath> getItems();
    public A withItems(List<KeyToPath> items);
    public A withItems(KeyToPath... items);
    public ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItem();
    public ConfigMapVolumeSourceFluent.ItemsNested<A> addNewItemLike(KeyToPath item);
    public A addNewItem(String key,String path);
    public String getName();
    public A withName(String name);

    public interface ItemsNested<N> extends Nested<N>,KeyToPathFluent<ConfigMapVolumeSourceFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}


}
