package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Long;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.validation.Valid;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeleteOptionsFluentImpl<A extends DeleteOptionsFluent<A>> extends BaseFluent<A> implements DeleteOptionsFluent<A>{

    private String apiVersion;
    private Long gracePeriodSeconds;
    private String kind;
    private Boolean orphanDependents;
    private VisitableBuilder<? extends Preconditions,?> preconditions;

    public DeleteOptionsFluentImpl(){
    }
    public DeleteOptionsFluentImpl(DeleteOptions instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withGracePeriodSeconds(instance.getGracePeriodSeconds()); 
            this.withKind(instance.getKind()); 
            this.withOrphanDependents(instance.getOrphanDependents()); 
            this.withPreconditions(instance.getPreconditions()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public Long getGracePeriodSeconds(){
            return this.gracePeriodSeconds;
    }

    public A withGracePeriodSeconds(Long gracePeriodSeconds){
            this.gracePeriodSeconds=gracePeriodSeconds; return (A) this;
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public Boolean isOrphanDependents(){
            return this.orphanDependents;
    }

    public A withOrphanDependents(Boolean orphanDependents){
            this.orphanDependents=orphanDependents; return (A) this;
    }

    public Preconditions getPreconditions(){
            return this.preconditions!=null?this.preconditions.build():null;
    }

    public A withPreconditions(Preconditions preconditions){
            if (preconditions!=null){ this.preconditions= new PreconditionsBuilder(preconditions); _visitables.add(this.preconditions);} return (A) this;
    }

    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditions(){
            return new PreconditionsNestedImpl();
    }

    public DeleteOptionsFluent.PreconditionsNested<A> withNewPreconditionsLike(Preconditions item){
            return new PreconditionsNestedImpl(item);
    }

    public DeleteOptionsFluent.PreconditionsNested<A> editPreconditions(){
            return withNewPreconditionsLike(getPreconditions());
    }

    public A withNewPreconditions(String uid){
            return (A)withPreconditions(new Preconditions(uid));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeleteOptionsFluentImpl that = (DeleteOptionsFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (gracePeriodSeconds != null ? !gracePeriodSeconds.equals(that.gracePeriodSeconds) :that.gracePeriodSeconds != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (orphanDependents != null ? !orphanDependents.equals(that.orphanDependents) :that.orphanDependents != null) return false;
            if (preconditions != null ? !preconditions.equals(that.preconditions) :that.preconditions != null) return false;
            return true;
    }


    public class PreconditionsNestedImpl<N> extends PreconditionsFluentImpl<DeleteOptionsFluent.PreconditionsNested<N>> implements DeleteOptionsFluent.PreconditionsNested<N>,Nested<N>{

            private final PreconditionsBuilder builder;
    
            PreconditionsNestedImpl(){
                    this.builder = new PreconditionsBuilder(this);
            }
            PreconditionsNestedImpl(Preconditions item){
                    this.builder = new PreconditionsBuilder(this, item);
            }
    
    public N and(){
            return (N) DeleteOptionsFluentImpl.this.withPreconditions(builder.build());
    }
    public N endPreconditions(){
            return and();
    }

}


}
