package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface PetSetListFluent<A extends PetSetListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(PetSet... items);
    public A removeFromItems(PetSet... items);
    public List<PetSet> getItems();
    public A withItems(List<PetSet> items);
    public A withItems(PetSet... items);
    public PetSetListFluent.ItemsNested<A> addNewItem();
    public PetSetListFluent.ItemsNested<A> addNewItemLike(PetSet item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PetSetListFluent.MetadataNested<A> withNewMetadata();
    public PetSetListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PetSetListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,PetSetFluent<PetSetListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<PetSetListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
