package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface ImageStreamListFluent<A extends ImageStreamListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ImageStream... items);
    public A removeFromItems(ImageStream... items);
    public List<ImageStream> getItems();
    public A withItems(List<ImageStream> items);
    public A withItems(ImageStream... items);
    public ImageStreamListFluent.ItemsNested<A> addNewItem();
    public ImageStreamListFluent.ItemsNested<A> addNewItemLike(ImageStream item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ImageStreamListFluent.MetadataNested<A> withNewMetadata();
    public ImageStreamListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ImageStreamListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,ImageStreamFluent<ImageStreamListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<ImageStreamListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
