package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface NamedRoleBindingFluent<A extends NamedRoleBindingFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public RoleBinding getRoleBinding();
    public A withRoleBinding(RoleBinding roleBinding);
    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBinding();
    public NamedRoleBindingFluent.RoleBindingNested<A> withNewRoleBindingLike(RoleBinding item);
    public NamedRoleBindingFluent.RoleBindingNested<A> editRoleBinding();

    public interface RoleBindingNested<N> extends Nested<N>,RoleBindingFluent<NamedRoleBindingFluent.RoleBindingNested<N>>{

        
    public N endRoleBinding();    public N and();
}


}
