package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;

public interface RoleBindingListFluent<A extends RoleBindingListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(RoleBinding... items);
    public A removeFromItems(RoleBinding... items);
    public List<RoleBinding> getItems();
    public A withItems(List<RoleBinding> items);
    public A withItems(RoleBinding... items);
    public RoleBindingListFluent.ItemsNested<A> addNewItem();
    public RoleBindingListFluent.ItemsNested<A> addNewItemLike(RoleBinding item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public RoleBindingListFluent.MetadataNested<A> withNewMetadata();
    public RoleBindingListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public RoleBindingListFluent.MetadataNested<A> editMetadata();
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends Nested<N>,RoleBindingFluent<RoleBindingListFluent.ItemsNested<N>>{

        
    public N endItem();    public N and();
}
    public interface MetadataNested<N> extends Nested<N>,ListMetaFluent<RoleBindingListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
