package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;

public interface RouteStatusFluent<A extends RouteStatusFluent<A>> extends Fluent<A>{


    public A addToIngress(RouteIngress... items);
    public A removeFromIngress(RouteIngress... items);
    public List<RouteIngress> getIngress();
    public A withIngress(List<RouteIngress> ingress);
    public A withIngress(RouteIngress... ingress);
    public RouteStatusFluent.IngressNested<A> addNewIngress();
    public RouteStatusFluent.IngressNested<A> addNewIngressLike(RouteIngress item);

    public interface IngressNested<N> extends Nested<N>,RouteIngressFluent<RouteStatusFluent.IngressNested<N>>{

        
    public N endIngress();    public N and();
}


}
