package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.Integer;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.String;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;

public interface ReplicaSetSpecFluent<A extends ReplicaSetSpecFluent<A>> extends Fluent<A>{


    public Integer getReplicas();
    public A withReplicas(Integer replicas);
    public LabelSelector getSelector();
    public A withSelector(LabelSelector selector);
    public ReplicaSetSpecFluent.SelectorNested<A> withNewSelector();
    public ReplicaSetSpecFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
    public ReplicaSetSpecFluent.SelectorNested<A> editSelector();
    public PodTemplateSpec getTemplate();
    public A withTemplate(PodTemplateSpec template);
    public ReplicaSetSpecFluent.TemplateNested<A> withNewTemplate();
    public ReplicaSetSpecFluent.TemplateNested<A> withNewTemplateLike(PodTemplateSpec item);
    public ReplicaSetSpecFluent.TemplateNested<A> editTemplate();

    public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<ReplicaSetSpecFluent.SelectorNested<N>>{

        
    public N endSelector();    public N and();
}
    public interface TemplateNested<N> extends Nested<N>,PodTemplateSpecFluent<ReplicaSetSpecFluent.TemplateNested<N>>{

        
    public N endTemplate();    public N and();
}


}
