package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.Valid;
import java.util.ArrayList;
import java.lang.String;
import java.lang.Object;
import io.fabric8.kubernetes.api.builder.Nested;

public class DeploymentDetailsFluentImpl<A extends DeploymentDetailsFluent<A>> extends BaseFluent<A> implements DeploymentDetailsFluent<A>{

    private List<VisitableBuilder<? extends DeploymentCause,?>> causes =  new ArrayList<VisitableBuilder<? extends DeploymentCause,?>>();
    private String message;

    public DeploymentDetailsFluentImpl(){
    }
    public DeploymentDetailsFluentImpl(DeploymentDetails instance){
            this.withCauses(instance.getCauses()); 
            this.withMessage(instance.getMessage()); 
    }

    public A addToCauses(DeploymentCause... items){
            for (DeploymentCause item : items) {DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);_visitables.add(builder);this.causes.add(builder);} return (A)this;
    }

    public A removeFromCauses(DeploymentCause... items){
            for (DeploymentCause item : items) {DeploymentCauseBuilder builder = new DeploymentCauseBuilder(item);_visitables.remove(builder);this.causes.remove(builder);} return (A)this;
    }

    public List<DeploymentCause> getCauses(){
            return build(causes);
    }

    public A withCauses(List<DeploymentCause> causes){
            this.causes.clear();
            if (causes != null) {for (DeploymentCause item : causes){this.addToCauses(item);}} return (A) this;
    }

    public A withCauses(DeploymentCause... causes){
            this.causes.clear(); if (causes != null) {for (DeploymentCause item :causes){ this.addToCauses(item);}} return (A) this;
    }

    public DeploymentDetailsFluent.CausesNested<A> addNewCause(){
            return new CausesNestedImpl();
    }

    public DeploymentDetailsFluent.CausesNested<A> addNewCauseLike(DeploymentCause item){
            return new CausesNestedImpl(item);
    }

    public String getMessage(){
            return this.message;
    }

    public A withMessage(String message){
            this.message=message; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DeploymentDetailsFluentImpl that = (DeploymentDetailsFluentImpl) o;
            if (causes != null ? !causes.equals(that.causes) :that.causes != null) return false;
            if (message != null ? !message.equals(that.message) :that.message != null) return false;
            return true;
    }


    public class CausesNestedImpl<N> extends DeploymentCauseFluentImpl<DeploymentDetailsFluent.CausesNested<N>> implements DeploymentDetailsFluent.CausesNested<N>,Nested<N>{

            private final DeploymentCauseBuilder builder;
    
            CausesNestedImpl(){
                    this.builder = new DeploymentCauseBuilder(this);
            }
            CausesNestedImpl(DeploymentCause item){
                    this.builder = new DeploymentCauseBuilder(this, item);
            }
    
    public N endCause(){
            return and();
    }
    public N and(){
            return (N) DeploymentDetailsFluentImpl.this.addToCauses(builder.build());
    }

}


}
