package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Integer;
import javax.validation.constraints.NotNull;
import java.lang.Object;

public class RouteTargetReferenceFluentImpl<A extends RouteTargetReferenceFluent<A>> extends BaseFluent<A> implements RouteTargetReferenceFluent<A>{

    private String kind;
    private String name;
    private Integer weight;

    public RouteTargetReferenceFluentImpl(){
    }
    public RouteTargetReferenceFluentImpl(RouteTargetReference instance){
            this.withKind(instance.getKind()); 
            this.withName(instance.getName()); 
            this.withWeight(instance.getWeight()); 
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public String getName(){
            return this.name;
    }

    public A withName(String name){
            this.name=name; return (A) this;
    }

    public Integer getWeight(){
            return this.weight;
    }

    public A withWeight(Integer weight){
            this.weight=weight; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RouteTargetReferenceFluentImpl that = (RouteTargetReferenceFluentImpl) o;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (name != null ? !name.equals(that.name) :that.name != null) return false;
            if (weight != null ? !weight.equals(that.weight) :that.weight != null) return false;
            return true;
    }




}
