/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.ContainerStateWaiting;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingFluent;
import io.fabric8.kubernetes.api.model.ContainerStateWaitingFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class ContainerStateWaitingBuilder
extends ContainerStateWaitingFluentImpl<ContainerStateWaitingBuilder>
implements VisitableBuilder<ContainerStateWaiting, ContainerStateWaitingBuilder> {
    ContainerStateWaitingFluent<?> fluent;
    Boolean validationEnabled;

    public ContainerStateWaitingBuilder() {
        this(true);
    }

    public ContainerStateWaitingBuilder(Boolean validationEnabled) {
        this(new ContainerStateWaiting(), validationEnabled);
    }

    public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new ContainerStateWaiting(), validationEnabled);
    }

    public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent, ContainerStateWaiting instance) {
        this(fluent, instance, true);
    }

    public ContainerStateWaitingBuilder(ContainerStateWaitingFluent<?> fluent, ContainerStateWaiting instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withMessage(instance.getMessage());
        fluent.withReason(instance.getReason());
        this.validationEnabled = validationEnabled;
    }

    public ContainerStateWaitingBuilder(ContainerStateWaiting instance) {
        this(instance, (Boolean)true);
    }

    public ContainerStateWaitingBuilder(ContainerStateWaiting instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withMessage(instance.getMessage());
        this.withReason(instance.getReason());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public ContainerStateWaiting build() {
        ContainerStateWaiting buildable = new ContainerStateWaiting(this.fluent.getMessage(), this.fluent.getReason());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ContainerStateWaitingBuilder that = (ContainerStateWaitingBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

