package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class BaseKubernetesListBuilder extends BaseKubernetesListFluentImpl<BaseKubernetesListBuilder> implements VisitableBuilder<BaseKubernetesList,BaseKubernetesListBuilder>{

    BaseKubernetesListFluent<?> fluent;
    Boolean validationEnabled;

    public BaseKubernetesListBuilder(){
            this(true);
    }
    public BaseKubernetesListBuilder(Boolean validationEnabled){
            this(new BaseKubernetesList(), validationEnabled);
    }
    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent){
            this(fluent, true);
    }
    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BaseKubernetesList(), validationEnabled);
    }
    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent,BaseKubernetesList instance){
            this(fluent, instance, true);
    }
    public BaseKubernetesListBuilder(BaseKubernetesListFluent<?> fluent,BaseKubernetesList instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withItems(instance.getItems()); 
            fluent.withKind(instance.getKind()); 
            fluent.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }
    public BaseKubernetesListBuilder(BaseKubernetesList instance){
            this(instance,true);
    }
    public BaseKubernetesListBuilder(BaseKubernetesList instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
            this.validationEnabled = validationEnabled; 
    }

    public BaseKubernetesList build(){
            BaseKubernetesList buildable = new BaseKubernetesList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BaseKubernetesListBuilder that = (BaseKubernetesListBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
