package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface BindingFluent<A extends BindingFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public BindingFluent.MetadataNested<A> withNewMetadata();
    public BindingFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public BindingFluent.MetadataNested<A> editMetadata();
    public BindingFluent.MetadataNested<A> editOrNewMetadata();
    public BindingFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ObjectReference getTarget();
    public A withTarget(ObjectReference target);
    public BindingFluent.TargetNested<A> withNewTarget();
    public BindingFluent.TargetNested<A> withNewTargetLike(ObjectReference item);
    public BindingFluent.TargetNested<A> editTarget();
    public BindingFluent.TargetNested<A> editOrNewTarget();
    public BindingFluent.TargetNested<A> editOrNewTargetLike(ObjectReference item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<BindingFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface TargetNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<BindingFluent.TargetNested<N>>{

        
    public N and();    public N endTarget();
}


}
