package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import io.sundr.builder.annotations.Buildable;
import javax.validation.constraints.Pattern;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ContainerStatusFluent<A extends ContainerStatusFluent<A>> extends Fluent<A>{


    public String getContainerID();
    public A withContainerID(String containerID);
    public String getImage();
    public A withImage(String image);
    public String getImageID();
    public A withImageID(String imageID);
    public ContainerState getLastState();
    public A withLastState(ContainerState lastState);
    public ContainerStatusFluent.LastStateNested<A> withNewLastState();
    public ContainerStatusFluent.LastStateNested<A> withNewLastStateLike(ContainerState item);
    public ContainerStatusFluent.LastStateNested<A> editLastState();
    public ContainerStatusFluent.LastStateNested<A> editOrNewLastState();
    public ContainerStatusFluent.LastStateNested<A> editOrNewLastStateLike(ContainerState item);
    public String getName();
    public A withName(String name);
    public Boolean isReady();
    public A withReady(Boolean ready);
    public Integer getRestartCount();
    public A withRestartCount(Integer restartCount);
    public ContainerState getState();
    public A withState(ContainerState state);
    public ContainerStatusFluent.StateNested<A> withNewState();
    public ContainerStatusFluent.StateNested<A> withNewStateLike(ContainerState item);
    public ContainerStatusFluent.StateNested<A> editState();
    public ContainerStatusFluent.StateNested<A> editOrNewState();
    public ContainerStatusFluent.StateNested<A> editOrNewStateLike(ContainerState item);

    public interface LastStateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStateFluent<ContainerStatusFluent.LastStateNested<N>>{

        
    public N and();    public N endLastState();
}
    public interface StateNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStateFluent<ContainerStatusFluent.StateNested<N>>{

        
    public N and();    public N endState();
}


}
