package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class DownwardAPIVolumeSourceBuilder extends DownwardAPIVolumeSourceFluentImpl<DownwardAPIVolumeSourceBuilder> implements VisitableBuilder<DownwardAPIVolumeSource,DownwardAPIVolumeSourceBuilder>{

    DownwardAPIVolumeSourceFluent<?> fluent;
    Boolean validationEnabled;

    public DownwardAPIVolumeSourceBuilder(){
            this(true);
    }
    public DownwardAPIVolumeSourceBuilder(Boolean validationEnabled){
            this(new DownwardAPIVolumeSource(), validationEnabled);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent){
            this(fluent, true);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new DownwardAPIVolumeSource(), validationEnabled);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent,DownwardAPIVolumeSource instance){
            this(fluent, instance, true);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSourceFluent<?> fluent,DownwardAPIVolumeSource instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withItems(instance.getItems()); 
            this.validationEnabled = validationEnabled; 
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSource instance){
            this(instance,true);
    }
    public DownwardAPIVolumeSourceBuilder(DownwardAPIVolumeSource instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withItems(instance.getItems()); 
            this.validationEnabled = validationEnabled; 
    }

    public DownwardAPIVolumeSource build(){
            DownwardAPIVolumeSource buildable = new DownwardAPIVolumeSource(fluent.getItems());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            DownwardAPIVolumeSourceBuilder that = (DownwardAPIVolumeSourceBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
