package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface EndpointsFluent<A extends EndpointsFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public EndpointsFluent.MetadataNested<A> withNewMetadata();
    public EndpointsFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public EndpointsFluent.MetadataNested<A> editMetadata();
    public EndpointsFluent.MetadataNested<A> editOrNewMetadata();
    public EndpointsFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public A addToSubsets(EndpointSubset... items);
    public A removeFromSubsets(EndpointSubset... items);
    public List<EndpointSubset> getSubsets();
    public A withSubsets(List<EndpointSubset> subsets);
    public A withSubsets(EndpointSubset... subsets);
    public EndpointsFluent.SubsetsNested<A> addNewSubset();
    public EndpointsFluent.SubsetsNested<A> addNewSubsetLike(EndpointSubset item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<EndpointsFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SubsetsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointSubsetFluent<EndpointsFluent.SubsetsNested<N>>{

        
    public N and();    public N endSubset();
}


}
