package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface EndpointsListFluent<A extends EndpointsListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Endpoints... items);
    public A removeFromItems(Endpoints... items);
    public List<Endpoints> getItems();
    public A withItems(List<Endpoints> items);
    public A withItems(Endpoints... items);
    public EndpointsListFluent.ItemsNested<A> addNewItem();
    public EndpointsListFluent.ItemsNested<A> addNewItemLike(Endpoints item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public EndpointsListFluent.MetadataNested<A> withNewMetadata();
    public EndpointsListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public EndpointsListFluent.MetadataNested<A> editMetadata();
    public EndpointsListFluent.MetadataNested<A> editOrNewMetadata();
    public EndpointsListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EndpointsFluent<EndpointsListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<EndpointsListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
