package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class EventBuilder extends EventFluentImpl<EventBuilder> implements VisitableBuilder<Event,EventBuilder>{

    EventFluent<?> fluent;
    Boolean validationEnabled;

    public EventBuilder(){
            this(true);
    }
    public EventBuilder(Boolean validationEnabled){
            this(new Event(), validationEnabled);
    }
    public EventBuilder(EventFluent<?> fluent){
            this(fluent, true);
    }
    public EventBuilder(EventFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Event(), validationEnabled);
    }
    public EventBuilder(EventFluent<?> fluent,Event instance){
            this(fluent, instance, true);
    }
    public EventBuilder(EventFluent<?> fluent,Event instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiVersion(instance.getApiVersion()); 
            fluent.withCount(instance.getCount()); 
            fluent.withFirstTimestamp(instance.getFirstTimestamp()); 
            fluent.withInvolvedObject(instance.getInvolvedObject()); 
            fluent.withKind(instance.getKind()); 
            fluent.withLastTimestamp(instance.getLastTimestamp()); 
            fluent.withMessage(instance.getMessage()); 
            fluent.withMetadata(instance.getMetadata()); 
            fluent.withReason(instance.getReason()); 
            fluent.withSource(instance.getSource()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public EventBuilder(Event instance){
            this(instance,true);
    }
    public EventBuilder(Event instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiVersion(instance.getApiVersion()); 
            this.withCount(instance.getCount()); 
            this.withFirstTimestamp(instance.getFirstTimestamp()); 
            this.withInvolvedObject(instance.getInvolvedObject()); 
            this.withKind(instance.getKind()); 
            this.withLastTimestamp(instance.getLastTimestamp()); 
            this.withMessage(instance.getMessage()); 
            this.withMetadata(instance.getMetadata()); 
            this.withReason(instance.getReason()); 
            this.withSource(instance.getSource()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public Event build(){
            Event buildable = new Event(fluent.getApiVersion(),fluent.getCount(),fluent.getFirstTimestamp(),fluent.getInvolvedObject(),fluent.getKind(),fluent.getLastTimestamp(),fluent.getMessage(),fluent.getMetadata(),fluent.getReason(),fluent.getSource(),fluent.getType());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            EventBuilder that = (EventBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
