package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface EventFluent<A extends EventFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Integer getCount();
    public A withCount(Integer count);
    public String getFirstTimestamp();
    public A withFirstTimestamp(String firstTimestamp);
    public ObjectReference getInvolvedObject();
    public A withInvolvedObject(ObjectReference involvedObject);
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObject();
    public EventFluent.InvolvedObjectNested<A> withNewInvolvedObjectLike(ObjectReference item);
    public EventFluent.InvolvedObjectNested<A> editInvolvedObject();
    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObject();
    public EventFluent.InvolvedObjectNested<A> editOrNewInvolvedObjectLike(ObjectReference item);
    public String getKind();
    public A withKind(String kind);
    public String getLastTimestamp();
    public A withLastTimestamp(String lastTimestamp);
    public String getMessage();
    public A withMessage(String message);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public EventFluent.MetadataNested<A> withNewMetadata();
    public EventFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public EventFluent.MetadataNested<A> editMetadata();
    public EventFluent.MetadataNested<A> editOrNewMetadata();
    public EventFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public String getReason();
    public A withReason(String reason);
    public EventSource getSource();
    public A withSource(EventSource source);
    public EventFluent.SourceNested<A> withNewSource();
    public EventFluent.SourceNested<A> withNewSourceLike(EventSource item);
    public EventFluent.SourceNested<A> editSource();
    public EventFluent.SourceNested<A> editOrNewSource();
    public EventFluent.SourceNested<A> editOrNewSourceLike(EventSource item);
    public A withNewSource(String component,String host);
    public String getType();
    public A withType(String type);

    public interface InvolvedObjectNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<EventFluent.InvolvedObjectNested<N>>{

        
    public N and();    public N endInvolvedObject();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<EventFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SourceNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EventSourceFluent<EventFluent.SourceNested<N>>{

        
    public N and();    public N endSource();
}


}
