package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class FSGroupStrategyOptionsBuilder extends FSGroupStrategyOptionsFluentImpl<FSGroupStrategyOptionsBuilder> implements VisitableBuilder<FSGroupStrategyOptions,FSGroupStrategyOptionsBuilder>{

    FSGroupStrategyOptionsFluent<?> fluent;
    Boolean validationEnabled;

    public FSGroupStrategyOptionsBuilder(){
            this(true);
    }
    public FSGroupStrategyOptionsBuilder(Boolean validationEnabled){
            this(new FSGroupStrategyOptions(), validationEnabled);
    }
    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent){
            this(fluent, true);
    }
    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new FSGroupStrategyOptions(), validationEnabled);
    }
    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent,FSGroupStrategyOptions instance){
            this(fluent, instance, true);
    }
    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptionsFluent<?> fluent,FSGroupStrategyOptions instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withRanges(instance.getRanges()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptions instance){
            this(instance,true);
    }
    public FSGroupStrategyOptionsBuilder(FSGroupStrategyOptions instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withRanges(instance.getRanges()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public FSGroupStrategyOptions build(){
            FSGroupStrategyOptions buildable = new FSGroupStrategyOptions(fluent.getRanges(),fluent.getType());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            FSGroupStrategyOptionsBuilder that = (FSGroupStrategyOptionsBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
