package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class IDRangeBuilder extends IDRangeFluentImpl<IDRangeBuilder> implements VisitableBuilder<IDRange,IDRangeBuilder>{

    IDRangeFluent<?> fluent;
    Boolean validationEnabled;

    public IDRangeBuilder(){
            this(true);
    }
    public IDRangeBuilder(Boolean validationEnabled){
            this(new IDRange(), validationEnabled);
    }
    public IDRangeBuilder(IDRangeFluent<?> fluent){
            this(fluent, true);
    }
    public IDRangeBuilder(IDRangeFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IDRange(), validationEnabled);
    }
    public IDRangeBuilder(IDRangeFluent<?> fluent,IDRange instance){
            this(fluent, instance, true);
    }
    public IDRangeBuilder(IDRangeFluent<?> fluent,IDRange instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withMax(instance.getMax()); 
            fluent.withMin(instance.getMin()); 
            this.validationEnabled = validationEnabled; 
    }
    public IDRangeBuilder(IDRange instance){
            this(instance,true);
    }
    public IDRangeBuilder(IDRange instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withMax(instance.getMax()); 
            this.withMin(instance.getMin()); 
            this.validationEnabled = validationEnabled; 
    }

    public IDRange build(){
            IDRange buildable = new IDRange(fluent.getMax(),fluent.getMin());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IDRangeBuilder that = (IDRangeBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
