package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface PersistentVolumeListFluent<A extends PersistentVolumeListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(PersistentVolume... items);
    public A removeFromItems(PersistentVolume... items);
    public List<PersistentVolume> getItems();
    public A withItems(List<PersistentVolume> items);
    public A withItems(PersistentVolume... items);
    public PersistentVolumeListFluent.ItemsNested<A> addNewItem();
    public PersistentVolumeListFluent.ItemsNested<A> addNewItemLike(PersistentVolume item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public PersistentVolumeListFluent.MetadataNested<A> withNewMetadata();
    public PersistentVolumeListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public PersistentVolumeListFluent.MetadataNested<A> editMetadata();
    public PersistentVolumeListFluent.MetadataNested<A> editOrNewMetadata();
    public PersistentVolumeListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeFluent<PersistentVolumeListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<PersistentVolumeListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
