package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface PodStatusFluent<A extends PodStatusFluent<A>> extends Fluent<A>{


    public A addToConditions(PodCondition... items);
    public A removeFromConditions(PodCondition... items);
    public List<PodCondition> getConditions();
    public A withConditions(List<PodCondition> conditions);
    public A withConditions(PodCondition... conditions);
    public PodStatusFluent.ConditionsNested<A> addNewCondition();
    public PodStatusFluent.ConditionsNested<A> addNewConditionLike(PodCondition item);
    public A addToContainerStatuses(ContainerStatus... items);
    public A removeFromContainerStatuses(ContainerStatus... items);
    public List<ContainerStatus> getContainerStatuses();
    public A withContainerStatuses(List<ContainerStatus> containerStatuses);
    public A withContainerStatuses(ContainerStatus... containerStatuses);
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatus();
    public PodStatusFluent.ContainerStatusesNested<A> addNewContainerStatusLike(ContainerStatus item);
    public String getHostIP();
    public A withHostIP(String hostIP);
    public String getMessage();
    public A withMessage(String message);
    public String getPhase();
    public A withPhase(String phase);
    public String getPodIP();
    public A withPodIP(String podIP);
    public String getReason();
    public A withReason(String reason);
    public String getStartTime();
    public A withStartTime(String startTime);

    public interface ConditionsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PodConditionFluent<PodStatusFluent.ConditionsNested<N>>{

        
    public N and();    public N endCondition();
}
    public interface ContainerStatusesNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ContainerStatusFluent<PodStatusFluent.ContainerStatusesNested<N>>{

        
    public N and();    public N endContainerStatus();
}


}
