package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ReplicationControllerListFluent<A extends ReplicationControllerListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(ReplicationController... items);
    public A removeFromItems(ReplicationController... items);
    public List<ReplicationController> getItems();
    public A withItems(List<ReplicationController> items);
    public A withItems(ReplicationController... items);
    public ReplicationControllerListFluent.ItemsNested<A> addNewItem();
    public ReplicationControllerListFluent.ItemsNested<A> addNewItemLike(ReplicationController item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public ReplicationControllerListFluent.MetadataNested<A> withNewMetadata();
    public ReplicationControllerListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public ReplicationControllerListFluent.MetadataNested<A> editMetadata();
    public ReplicationControllerListFluent.MetadataNested<A> editOrNewMetadata();
    public ReplicationControllerListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicationControllerFluent<ReplicationControllerListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<ReplicationControllerListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
