package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface SecretListFluent<A extends SecretListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Secret... items);
    public A removeFromItems(Secret... items);
    public List<Secret> getItems();
    public A withItems(List<Secret> items);
    public A withItems(Secret... items);
    public SecretListFluent.ItemsNested<A> addNewItem();
    public SecretListFluent.ItemsNested<A> addNewItemLike(Secret item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public SecretListFluent.MetadataNested<A> withNewMetadata();
    public SecretListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public SecretListFluent.MetadataNested<A> editMetadata();
    public SecretListFluent.MetadataNested<A> editOrNewMetadata();
    public SecretListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretFluent<SecretListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<SecretListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
