package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import com.fasterxml.jackson.databind.JsonSerializer;
import java.lang.String;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.lang.Override;
import io.sundr.builder.annotations.Buildable;
import com.fasterxml.jackson.core.JsonParser;
import javax.validation.constraints.Pattern;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ServicePortFluent<A extends ServicePortFluent<A>> extends Fluent<A>{


    public String getName();
    public A withName(String name);
    public Integer getNodePort();
    public A withNodePort(Integer nodePort);
    public Integer getPort();
    public A withPort(Integer port);
    public String getProtocol();
    public A withProtocol(String protocol);
    public IntOrString getTargetPort();
    public A withTargetPort(IntOrString targetPort);
    public ServicePortFluent.TargetPortNested<A> withNewTargetPort();
    public ServicePortFluent.TargetPortNested<A> withNewTargetPortLike(IntOrString item);
    public ServicePortFluent.TargetPortNested<A> editTargetPort();
    public ServicePortFluent.TargetPortNested<A> editOrNewTargetPort();
    public ServicePortFluent.TargetPortNested<A> editOrNewTargetPortLike(IntOrString item);
    public A withNewTargetPort(Integer intVal);
    public A withNewTargetPort(String strVal);

    public interface TargetPortNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IntOrStringFluent<ServicePortFluent.TargetPortNested<N>>{

        
    public N and();    public N endTargetPort();
}


}
