package io.fabric8.kubernetes.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.Size;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.String;
import java.lang.Boolean;
import lombok.EqualsAndHashCode;
import javax.validation.Valid;
import java.lang.Object;
import java.util.Map;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.validation.constraints.Pattern;
import lombok.ToString;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import javax.annotation.Generated;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Integer;

public interface VolumeFluent<A extends VolumeFluent<A>> extends Fluent<A>{


    public AWSElasticBlockStoreVolumeSource getAwsElasticBlockStore();
    public A withAwsElasticBlockStore(AWSElasticBlockStoreVolumeSource awsElasticBlockStore);
    public VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStore();
    public VolumeFluent.AwsElasticBlockStoreNested<A> withNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item);
    public VolumeFluent.AwsElasticBlockStoreNested<A> editAwsElasticBlockStore();
    public VolumeFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStore();
    public VolumeFluent.AwsElasticBlockStoreNested<A> editOrNewAwsElasticBlockStoreLike(AWSElasticBlockStoreVolumeSource item);
    public A withNewAwsElasticBlockStore(String fsType,Integer partition,Boolean readOnly,String volumeID);
    public AzureFileVolumeSource getAzureFile();
    public A withAzureFile(AzureFileVolumeSource azureFile);
    public VolumeFluent.AzureFileNested<A> withNewAzureFile();
    public VolumeFluent.AzureFileNested<A> withNewAzureFileLike(AzureFileVolumeSource item);
    public VolumeFluent.AzureFileNested<A> editAzureFile();
    public VolumeFluent.AzureFileNested<A> editOrNewAzureFile();
    public VolumeFluent.AzureFileNested<A> editOrNewAzureFileLike(AzureFileVolumeSource item);
    public A withNewAzureFile(Boolean readOnly,String secretName,String shareName);
    public CephFSVolumeSource getCephfs();
    public A withCephfs(CephFSVolumeSource cephfs);
    public VolumeFluent.CephfsNested<A> withNewCephfs();
    public VolumeFluent.CephfsNested<A> withNewCephfsLike(CephFSVolumeSource item);
    public VolumeFluent.CephfsNested<A> editCephfs();
    public VolumeFluent.CephfsNested<A> editOrNewCephfs();
    public VolumeFluent.CephfsNested<A> editOrNewCephfsLike(CephFSVolumeSource item);
    public CinderVolumeSource getCinder();
    public A withCinder(CinderVolumeSource cinder);
    public VolumeFluent.CinderNested<A> withNewCinder();
    public VolumeFluent.CinderNested<A> withNewCinderLike(CinderVolumeSource item);
    public VolumeFluent.CinderNested<A> editCinder();
    public VolumeFluent.CinderNested<A> editOrNewCinder();
    public VolumeFluent.CinderNested<A> editOrNewCinderLike(CinderVolumeSource item);
    public A withNewCinder(String fsType,Boolean readOnly,String volumeID);
    public ConfigMapVolumeSource getConfigMap();
    public A withConfigMap(ConfigMapVolumeSource configMap);
    public VolumeFluent.ConfigMapNested<A> withNewConfigMap();
    public VolumeFluent.ConfigMapNested<A> withNewConfigMapLike(ConfigMapVolumeSource item);
    public VolumeFluent.ConfigMapNested<A> editConfigMap();
    public VolumeFluent.ConfigMapNested<A> editOrNewConfigMap();
    public VolumeFluent.ConfigMapNested<A> editOrNewConfigMapLike(ConfigMapVolumeSource item);
    public DownwardAPIVolumeSource getDownwardAPI();
    public A withDownwardAPI(DownwardAPIVolumeSource downwardAPI);
    public VolumeFluent.DownwardAPINested<A> withNewDownwardAPI();
    public VolumeFluent.DownwardAPINested<A> withNewDownwardAPILike(DownwardAPIVolumeSource item);
    public VolumeFluent.DownwardAPINested<A> editDownwardAPI();
    public VolumeFluent.DownwardAPINested<A> editOrNewDownwardAPI();
    public VolumeFluent.DownwardAPINested<A> editOrNewDownwardAPILike(DownwardAPIVolumeSource item);
    public EmptyDirVolumeSource getEmptyDir();
    public A withEmptyDir(EmptyDirVolumeSource emptyDir);
    public VolumeFluent.EmptyDirNested<A> withNewEmptyDir();
    public VolumeFluent.EmptyDirNested<A> withNewEmptyDirLike(EmptyDirVolumeSource item);
    public VolumeFluent.EmptyDirNested<A> editEmptyDir();
    public VolumeFluent.EmptyDirNested<A> editOrNewEmptyDir();
    public VolumeFluent.EmptyDirNested<A> editOrNewEmptyDirLike(EmptyDirVolumeSource item);
    public A withNewEmptyDir(String medium);
    public FCVolumeSource getFc();
    public A withFc(FCVolumeSource fc);
    public VolumeFluent.FcNested<A> withNewFc();
    public VolumeFluent.FcNested<A> withNewFcLike(FCVolumeSource item);
    public VolumeFluent.FcNested<A> editFc();
    public VolumeFluent.FcNested<A> editOrNewFc();
    public VolumeFluent.FcNested<A> editOrNewFcLike(FCVolumeSource item);
    public FlexVolumeSource getFlexVolume();
    public A withFlexVolume(FlexVolumeSource flexVolume);
    public VolumeFluent.FlexVolumeNested<A> withNewFlexVolume();
    public VolumeFluent.FlexVolumeNested<A> withNewFlexVolumeLike(FlexVolumeSource item);
    public VolumeFluent.FlexVolumeNested<A> editFlexVolume();
    public VolumeFluent.FlexVolumeNested<A> editOrNewFlexVolume();
    public VolumeFluent.FlexVolumeNested<A> editOrNewFlexVolumeLike(FlexVolumeSource item);
    public FlockerVolumeSource getFlocker();
    public A withFlocker(FlockerVolumeSource flocker);
    public VolumeFluent.FlockerNested<A> withNewFlocker();
    public VolumeFluent.FlockerNested<A> withNewFlockerLike(FlockerVolumeSource item);
    public VolumeFluent.FlockerNested<A> editFlocker();
    public VolumeFluent.FlockerNested<A> editOrNewFlocker();
    public VolumeFluent.FlockerNested<A> editOrNewFlockerLike(FlockerVolumeSource item);
    public A withNewFlocker(String datasetName);
    public GCEPersistentDiskVolumeSource getGcePersistentDisk();
    public A withGcePersistentDisk(GCEPersistentDiskVolumeSource gcePersistentDisk);
    public VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDisk();
    public VolumeFluent.GcePersistentDiskNested<A> withNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item);
    public VolumeFluent.GcePersistentDiskNested<A> editGcePersistentDisk();
    public VolumeFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDisk();
    public VolumeFluent.GcePersistentDiskNested<A> editOrNewGcePersistentDiskLike(GCEPersistentDiskVolumeSource item);
    public A withNewGcePersistentDisk(String fsType,Integer partition,String pdName,Boolean readOnly);
    public GitRepoVolumeSource getGitRepo();
    public A withGitRepo(GitRepoVolumeSource gitRepo);
    public VolumeFluent.GitRepoNested<A> withNewGitRepo();
    public VolumeFluent.GitRepoNested<A> withNewGitRepoLike(GitRepoVolumeSource item);
    public VolumeFluent.GitRepoNested<A> editGitRepo();
    public VolumeFluent.GitRepoNested<A> editOrNewGitRepo();
    public VolumeFluent.GitRepoNested<A> editOrNewGitRepoLike(GitRepoVolumeSource item);
    public A withNewGitRepo(String directory,String repository,String revision);
    public GlusterfsVolumeSource getGlusterfs();
    public A withGlusterfs(GlusterfsVolumeSource glusterfs);
    public VolumeFluent.GlusterfsNested<A> withNewGlusterfs();
    public VolumeFluent.GlusterfsNested<A> withNewGlusterfsLike(GlusterfsVolumeSource item);
    public VolumeFluent.GlusterfsNested<A> editGlusterfs();
    public VolumeFluent.GlusterfsNested<A> editOrNewGlusterfs();
    public VolumeFluent.GlusterfsNested<A> editOrNewGlusterfsLike(GlusterfsVolumeSource item);
    public A withNewGlusterfs(String endpoints,String path,Boolean readOnly);
    public HostPathVolumeSource getHostPath();
    public A withHostPath(HostPathVolumeSource hostPath);
    public VolumeFluent.HostPathNested<A> withNewHostPath();
    public VolumeFluent.HostPathNested<A> withNewHostPathLike(HostPathVolumeSource item);
    public VolumeFluent.HostPathNested<A> editHostPath();
    public VolumeFluent.HostPathNested<A> editOrNewHostPath();
    public VolumeFluent.HostPathNested<A> editOrNewHostPathLike(HostPathVolumeSource item);
    public A withNewHostPath(String path);
    public ISCSIVolumeSource getIscsi();
    public A withIscsi(ISCSIVolumeSource iscsi);
    public VolumeFluent.IscsiNested<A> withNewIscsi();
    public VolumeFluent.IscsiNested<A> withNewIscsiLike(ISCSIVolumeSource item);
    public VolumeFluent.IscsiNested<A> editIscsi();
    public VolumeFluent.IscsiNested<A> editOrNewIscsi();
    public VolumeFluent.IscsiNested<A> editOrNewIscsiLike(ISCSIVolumeSource item);
    public DeprecatedDownwardAPIVolumeSource getMetadata();
    public A withMetadata(DeprecatedDownwardAPIVolumeSource metadata);
    public VolumeFluent.MetadataNested<A> withNewMetadata();
    public VolumeFluent.MetadataNested<A> withNewMetadataLike(DeprecatedDownwardAPIVolumeSource item);
    public VolumeFluent.MetadataNested<A> editMetadata();
    public VolumeFluent.MetadataNested<A> editOrNewMetadata();
    public VolumeFluent.MetadataNested<A> editOrNewMetadataLike(DeprecatedDownwardAPIVolumeSource item);
    public String getName();
    public A withName(String name);
    public NFSVolumeSource getNfs();
    public A withNfs(NFSVolumeSource nfs);
    public VolumeFluent.NfsNested<A> withNewNfs();
    public VolumeFluent.NfsNested<A> withNewNfsLike(NFSVolumeSource item);
    public VolumeFluent.NfsNested<A> editNfs();
    public VolumeFluent.NfsNested<A> editOrNewNfs();
    public VolumeFluent.NfsNested<A> editOrNewNfsLike(NFSVolumeSource item);
    public A withNewNfs(String path,Boolean readOnly,String server);
    public PersistentVolumeClaimVolumeSource getPersistentVolumeClaim();
    public A withPersistentVolumeClaim(PersistentVolumeClaimVolumeSource persistentVolumeClaim);
    public VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaim();
    public VolumeFluent.PersistentVolumeClaimNested<A> withNewPersistentVolumeClaimLike(PersistentVolumeClaimVolumeSource item);
    public VolumeFluent.PersistentVolumeClaimNested<A> editPersistentVolumeClaim();
    public VolumeFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaim();
    public VolumeFluent.PersistentVolumeClaimNested<A> editOrNewPersistentVolumeClaimLike(PersistentVolumeClaimVolumeSource item);
    public A withNewPersistentVolumeClaim(String claimName,Boolean readOnly);
    public RBDVolumeSource getRbd();
    public A withRbd(RBDVolumeSource rbd);
    public VolumeFluent.RbdNested<A> withNewRbd();
    public VolumeFluent.RbdNested<A> withNewRbdLike(RBDVolumeSource item);
    public VolumeFluent.RbdNested<A> editRbd();
    public VolumeFluent.RbdNested<A> editOrNewRbd();
    public VolumeFluent.RbdNested<A> editOrNewRbdLike(RBDVolumeSource item);
    public SecretVolumeSource getSecret();
    public A withSecret(SecretVolumeSource secret);
    public VolumeFluent.SecretNested<A> withNewSecret();
    public VolumeFluent.SecretNested<A> withNewSecretLike(SecretVolumeSource item);
    public VolumeFluent.SecretNested<A> editSecret();
    public VolumeFluent.SecretNested<A> editOrNewSecret();
    public VolumeFluent.SecretNested<A> editOrNewSecretLike(SecretVolumeSource item);
    public VsphereVirtualDiskVolumeSource getVsphereVolume();
    public A withVsphereVolume(VsphereVirtualDiskVolumeSource vsphereVolume);
    public VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolume();
    public VolumeFluent.VsphereVolumeNested<A> withNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item);
    public VolumeFluent.VsphereVolumeNested<A> editVsphereVolume();
    public VolumeFluent.VsphereVolumeNested<A> editOrNewVsphereVolume();
    public VolumeFluent.VsphereVolumeNested<A> editOrNewVsphereVolumeLike(VsphereVirtualDiskVolumeSource item);
    public A withNewVsphereVolume(String fsType,String volumePath);

    public interface AwsElasticBlockStoreNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AWSElasticBlockStoreVolumeSourceFluent<VolumeFluent.AwsElasticBlockStoreNested<N>>{

        
    public N and();    public N endAwsElasticBlockStore();
}
    public interface AzureFileNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AzureFileVolumeSourceFluent<VolumeFluent.AzureFileNested<N>>{

        
    public N and();    public N endAzureFile();
}
    public interface CephfsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CephFSVolumeSourceFluent<VolumeFluent.CephfsNested<N>>{

        
    public N and();    public N endCephfs();
}
    public interface CinderNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,CinderVolumeSourceFluent<VolumeFluent.CinderNested<N>>{

        
    public N and();    public N endCinder();
}
    public interface ConfigMapNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ConfigMapVolumeSourceFluent<VolumeFluent.ConfigMapNested<N>>{

        
    public N and();    public N endConfigMap();
}
    public interface DownwardAPINested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DownwardAPIVolumeSourceFluent<VolumeFluent.DownwardAPINested<N>>{

        
    public N and();    public N endDownwardAPI();
}
    public interface EmptyDirNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EmptyDirVolumeSourceFluent<VolumeFluent.EmptyDirNested<N>>{

        
    public N and();    public N endEmptyDir();
}
    public interface FcNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FCVolumeSourceFluent<VolumeFluent.FcNested<N>>{

        
    public N and();    public N endFc();
}
    public interface FlexVolumeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FlexVolumeSourceFluent<VolumeFluent.FlexVolumeNested<N>>{

        
    public N and();    public N endFlexVolume();
}
    public interface FlockerNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,FlockerVolumeSourceFluent<VolumeFluent.FlockerNested<N>>{

        
    public N and();    public N endFlocker();
}
    public interface GcePersistentDiskNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GCEPersistentDiskVolumeSourceFluent<VolumeFluent.GcePersistentDiskNested<N>>{

        
    public N and();    public N endGcePersistentDisk();
}
    public interface GitRepoNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GitRepoVolumeSourceFluent<VolumeFluent.GitRepoNested<N>>{

        
    public N and();    public N endGitRepo();
}
    public interface GlusterfsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,GlusterfsVolumeSourceFluent<VolumeFluent.GlusterfsNested<N>>{

        
    public N and();    public N endGlusterfs();
}
    public interface HostPathNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HostPathVolumeSourceFluent<VolumeFluent.HostPathNested<N>>{

        
    public N and();    public N endHostPath();
}
    public interface IscsiNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ISCSIVolumeSourceFluent<VolumeFluent.IscsiNested<N>>{

        
    public N and();    public N endIscsi();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,DeprecatedDownwardAPIVolumeSourceFluent<VolumeFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface NfsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,NFSVolumeSourceFluent<VolumeFluent.NfsNested<N>>{

        
    public N and();    public N endNfs();
}
    public interface PersistentVolumeClaimNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,PersistentVolumeClaimVolumeSourceFluent<VolumeFluent.PersistentVolumeClaimNested<N>>{

        
    public N and();    public N endPersistentVolumeClaim();
}
    public interface RbdNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,RBDVolumeSourceFluent<VolumeFluent.RbdNested<N>>{

        
    public N and();    public N endRbd();
}
    public interface SecretNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SecretVolumeSourceFluent<VolumeFluent.SecretNested<N>>{

        
    public N and();    public N endSecret();
}
    public interface VsphereVolumeNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,VsphereVirtualDiskVolumeSourceFluent<VolumeFluent.VsphereVolumeNested<N>>{

        
    public N and();    public N endVsphereVolume();
}


}
