package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface HorizontalPodAutoscalerFluent<A extends HorizontalPodAutoscalerFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadata();
    public HorizontalPodAutoscalerFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public HorizontalPodAutoscalerFluent.MetadataNested<A> editMetadata();
    public HorizontalPodAutoscalerFluent.MetadataNested<A> editOrNewMetadata();
    public HorizontalPodAutoscalerFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public HorizontalPodAutoscalerSpec getSpec();
    public A withSpec(HorizontalPodAutoscalerSpec spec);
    public HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpec();
    public HorizontalPodAutoscalerFluent.SpecNested<A> withNewSpecLike(HorizontalPodAutoscalerSpec item);
    public HorizontalPodAutoscalerFluent.SpecNested<A> editSpec();
    public HorizontalPodAutoscalerFluent.SpecNested<A> editOrNewSpec();
    public HorizontalPodAutoscalerFluent.SpecNested<A> editOrNewSpecLike(HorizontalPodAutoscalerSpec item);
    public HorizontalPodAutoscalerStatus getStatus();
    public A withStatus(HorizontalPodAutoscalerStatus status);
    public HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatus();
    public HorizontalPodAutoscalerFluent.StatusNested<A> withNewStatusLike(HorizontalPodAutoscalerStatus item);
    public HorizontalPodAutoscalerFluent.StatusNested<A> editStatus();
    public HorizontalPodAutoscalerFluent.StatusNested<A> editOrNewStatus();
    public HorizontalPodAutoscalerFluent.StatusNested<A> editOrNewStatusLike(HorizontalPodAutoscalerStatus item);
    public A withNewStatus(Integer currentCPUUtilizationPercentage,Integer currentReplicas,Integer desiredReplicas,String lastScaleTime,Long observedGeneration);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<HorizontalPodAutoscalerFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HorizontalPodAutoscalerSpecFluent<HorizontalPodAutoscalerFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,HorizontalPodAutoscalerStatusFluent<HorizontalPodAutoscalerFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
