package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import javax.validation.constraints.NotNull;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.ListMetaFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface IngressListFluent<A extends IngressListFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public A addToItems(Ingress... items);
    public A removeFromItems(Ingress... items);
    public List<Ingress> getItems();
    public A withItems(List<Ingress> items);
    public A withItems(Ingress... items);
    public IngressListFluent.ItemsNested<A> addNewItem();
    public IngressListFluent.ItemsNested<A> addNewItemLike(Ingress item);
    public String getKind();
    public A withKind(String kind);
    public ListMeta getMetadata();
    public A withMetadata(ListMeta metadata);
    public IngressListFluent.MetadataNested<A> withNewMetadata();
    public IngressListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item);
    public IngressListFluent.MetadataNested<A> editMetadata();
    public IngressListFluent.MetadataNested<A> editOrNewMetadata();
    public IngressListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item);
    public A withNewMetadata(String resourceVersion,String selfLink);

    public interface ItemsNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,IngressFluent<IngressListFluent.ItemsNested<N>>{

        
    public N and();    public N endItem();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ListMetaFluent<IngressListFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}


}
