package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class IngressStatusBuilder extends IngressStatusFluentImpl<IngressStatusBuilder> implements VisitableBuilder<IngressStatus,IngressStatusBuilder>{

    IngressStatusFluent<?> fluent;
    Boolean validationEnabled;

    public IngressStatusBuilder(){
            this(true);
    }
    public IngressStatusBuilder(Boolean validationEnabled){
            this(new IngressStatus(), validationEnabled);
    }
    public IngressStatusBuilder(IngressStatusFluent<?> fluent){
            this(fluent, true);
    }
    public IngressStatusBuilder(IngressStatusFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new IngressStatus(), validationEnabled);
    }
    public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance){
            this(fluent, instance, true);
    }
    public IngressStatusBuilder(IngressStatusFluent<?> fluent,IngressStatus instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withLoadBalancer(instance.getLoadBalancer()); 
            this.validationEnabled = validationEnabled; 
    }
    public IngressStatusBuilder(IngressStatus instance){
            this(instance,true);
    }
    public IngressStatusBuilder(IngressStatus instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withLoadBalancer(instance.getLoadBalancer()); 
            this.validationEnabled = validationEnabled; 
    }

    public IngressStatus build(){
            IngressStatus buildable = new IngressStatus(fluent.getLoadBalancer());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressStatusBuilder that = (IngressStatusBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
