package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.String;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class IngressTLSFluentImpl<A extends IngressTLSFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements IngressTLSFluent<A>{

    private List<String> hosts = new ArrayList<String>();
    private String secretName;

    public IngressTLSFluentImpl(){
    }
    public IngressTLSFluentImpl(IngressTLS instance){
            this.withHosts(instance.getHosts()); 
            this.withSecretName(instance.getSecretName()); 
    }

    public A addToHosts(String... items){
            for (String item : items) {this.hosts.add(item);} return (A)this;
    }

    public A removeFromHosts(String... items){
            for (String item : items) {this.hosts.remove(item);} return (A)this;
    }

    public List<String> getHosts(){
            return this.hosts;
    }

    public A withHosts(List<String> hosts){
            this.hosts.clear();
            if (hosts != null) {for (String item : hosts){this.addToHosts(item);}} return (A) this;
    }

    public A withHosts(String... hosts){
            this.hosts.clear(); if (hosts != null) {for (String item :hosts){ this.addToHosts(item);}} return (A) this;
    }

    public String getSecretName(){
            return this.secretName;
    }

    public A withSecretName(String secretName){
            this.secretName=secretName; return (A) this;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            IngressTLSFluentImpl that = (IngressTLSFluentImpl) o;
            if (hosts != null ? !hosts.equals(that.hosts) :that.hosts != null) return false;
            if (secretName != null ? !secretName.equals(that.secretName) :that.secretName != null) return false;
            return true;
    }




}
