package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import javax.validation.Valid;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface JobFluent<A extends JobFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public JobFluent.MetadataNested<A> withNewMetadata();
    public JobFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public JobFluent.MetadataNested<A> editMetadata();
    public JobFluent.MetadataNested<A> editOrNewMetadata();
    public JobFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public JobSpec getSpec();
    public A withSpec(JobSpec spec);
    public JobFluent.SpecNested<A> withNewSpec();
    public JobFluent.SpecNested<A> withNewSpecLike(JobSpec item);
    public JobFluent.SpecNested<A> editSpec();
    public JobFluent.SpecNested<A> editOrNewSpec();
    public JobFluent.SpecNested<A> editOrNewSpecLike(JobSpec item);
    public JobStatus getStatus();
    public A withStatus(JobStatus status);
    public JobFluent.StatusNested<A> withNewStatus();
    public JobFluent.StatusNested<A> withNewStatusLike(JobStatus item);
    public JobFluent.StatusNested<A> editStatus();
    public JobFluent.StatusNested<A> editOrNewStatus();
    public JobFluent.StatusNested<A> editOrNewStatusLike(JobStatus item);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<JobFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JobSpecFluent<JobFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,JobStatusFluent<JobFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
