package io.fabric8.kubernetes.api.model.extensions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Integer;
import javax.validation.Valid;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface ReplicaSetFluent<A extends ReplicaSetFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public String getKind();
    public A withKind(String kind);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public ReplicaSetFluent.MetadataNested<A> withNewMetadata();
    public ReplicaSetFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public ReplicaSetFluent.MetadataNested<A> editMetadata();
    public ReplicaSetFluent.MetadataNested<A> editOrNewMetadata();
    public ReplicaSetFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public ReplicaSetSpec getSpec();
    public A withSpec(ReplicaSetSpec spec);
    public ReplicaSetFluent.SpecNested<A> withNewSpec();
    public ReplicaSetFluent.SpecNested<A> withNewSpecLike(ReplicaSetSpec item);
    public ReplicaSetFluent.SpecNested<A> editSpec();
    public ReplicaSetFluent.SpecNested<A> editOrNewSpec();
    public ReplicaSetFluent.SpecNested<A> editOrNewSpecLike(ReplicaSetSpec item);
    public ReplicaSetStatus getStatus();
    public A withStatus(ReplicaSetStatus status);
    public ReplicaSetFluent.StatusNested<A> withNewStatus();
    public ReplicaSetFluent.StatusNested<A> withNewStatusLike(ReplicaSetStatus item);
    public ReplicaSetFluent.StatusNested<A> editStatus();
    public ReplicaSetFluent.StatusNested<A> editOrNewStatus();
    public ReplicaSetFluent.StatusNested<A> editOrNewStatusLike(ReplicaSetStatus item);
    public A withNewStatus(Integer fullyLabeledReplicas,Long observedGeneration,Integer replicas);

    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<ReplicaSetFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface SpecNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicaSetSpecFluent<ReplicaSetFluent.SpecNested<N>>{

        
    public N and();    public N endSpec();
}
    public interface StatusNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ReplicaSetStatusFluent<ReplicaSetFluent.StatusNested<N>>{

        
    public N and();    public N endStatus();
}


}
