package io.fabric8.kubernetes.api.model.extensions;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ListMeta;
import io.fabric8.kubernetes.api.model.ListMetaBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ListMetaFluentImpl;
import java.lang.Object;
import lombok.ToString;

public class ThirdPartyResourceListFluentImpl<A extends ThirdPartyResourceListFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements ThirdPartyResourceListFluent<A>{

    private String apiVersion;
    private List<VisitableBuilder<? extends ThirdPartyResource,?>> items =  new ArrayList<VisitableBuilder<? extends ThirdPartyResource,?>>();
    private String kind;
    private VisitableBuilder<? extends ListMeta,?> metadata;

    public ThirdPartyResourceListFluentImpl(){
    }
    public ThirdPartyResourceListFluentImpl(ThirdPartyResourceList instance){
            this.withApiVersion(instance.getApiVersion()); 
            this.withItems(instance.getItems()); 
            this.withKind(instance.getKind()); 
            this.withMetadata(instance.getMetadata()); 
    }

    public String getApiVersion(){
            return this.apiVersion;
    }

    public A withApiVersion(String apiVersion){
            this.apiVersion=apiVersion; return (A) this;
    }

    public A addToItems(ThirdPartyResource... items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.add(builder);this.items.add(builder);} return (A)this;
    }

    public A removeFromItems(ThirdPartyResource... items){
            for (ThirdPartyResource item : items) {ThirdPartyResourceBuilder builder = new ThirdPartyResourceBuilder(item);_visitables.remove(builder);this.items.remove(builder);} return (A)this;
    }

    public List<ThirdPartyResource> getItems(){
            return build(items);
    }

    public A withItems(List<ThirdPartyResource> items){
            _visitables.removeAll(this.items);
            this.items.clear();
            if (items != null) {for (ThirdPartyResource item : items){this.addToItems(item);}} return (A) this;
    }

    public A withItems(ThirdPartyResource... items){
            this.items.clear(); if (items != null) {for (ThirdPartyResource item :items){ this.addToItems(item);}} return (A) this;
    }

    public ThirdPartyResourceListFluent.ItemsNested<A> addNewItem(){
            return new ItemsNestedImpl();
    }

    public ThirdPartyResourceListFluent.ItemsNested<A> addNewItemLike(ThirdPartyResource item){
            return new ItemsNestedImpl(item);
    }

    public String getKind(){
            return this.kind;
    }

    public A withKind(String kind){
            this.kind=kind; return (A) this;
    }

    public ListMeta getMetadata(){
            return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(ListMeta metadata){
            _visitables.remove(this.metadata);
            if (metadata!=null){ this.metadata= new ListMetaBuilder(metadata); _visitables.add(this.metadata);} return (A) this;
    }

    public ThirdPartyResourceListFluent.MetadataNested<A> withNewMetadata(){
            return new MetadataNestedImpl();
    }

    public ThirdPartyResourceListFluent.MetadataNested<A> withNewMetadataLike(ListMeta item){
            return new MetadataNestedImpl(item);
    }

    public ThirdPartyResourceListFluent.MetadataNested<A> editMetadata(){
            return withNewMetadataLike(getMetadata());
    }

    public ThirdPartyResourceListFluent.MetadataNested<A> editOrNewMetadata(){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ListMetaBuilder().build());
    }

    public ThirdPartyResourceListFluent.MetadataNested<A> editOrNewMetadataLike(ListMeta item){
            return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A withNewMetadata(String resourceVersion,String selfLink){
            return (A)withMetadata(new ListMeta(resourceVersion, selfLink));
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            ThirdPartyResourceListFluentImpl that = (ThirdPartyResourceListFluentImpl) o;
            if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
            if (items != null ? !items.equals(that.items) :that.items != null) return false;
            if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
            if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
            return true;
    }


    public class ItemsNestedImpl<N> extends ThirdPartyResourceFluentImpl<ThirdPartyResourceListFluent.ItemsNested<N>> implements ThirdPartyResourceListFluent.ItemsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ThirdPartyResourceBuilder builder;
    
            ItemsNestedImpl(ThirdPartyResource item){
                    this.builder = new ThirdPartyResourceBuilder(this, item);
            }
            ItemsNestedImpl(){
                    this.builder = new ThirdPartyResourceBuilder(this);
            }
    
    public N and(){
            return (N) ThirdPartyResourceListFluentImpl.this.addToItems(builder.build());
    }
    public N endItem(){
            return and();
    }

}
    public class MetadataNestedImpl<N> extends ListMetaFluentImpl<ThirdPartyResourceListFluent.MetadataNested<N>> implements ThirdPartyResourceListFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ListMetaBuilder builder;
    
            MetadataNestedImpl(ListMeta item){
                    this.builder = new ListMetaBuilder(this, item);
            }
            MetadataNestedImpl(){
                    this.builder = new ListMetaBuilder(this);
            }
    
    public N and(){
            return (N) ThirdPartyResourceListFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata(){
            return and();
    }

}


}
