package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceFluentImpl;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluentImpl;
import io.fabric8.kubernetes.api.model.LocalObjectReferenceBuilder;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import io.fabric8.kubernetes.api.model.LocalObjectReference;
import java.lang.Object;
import lombok.ToString;

public class BuildOutputFluentImpl<A extends BuildOutputFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements BuildOutputFluent<A>{

    private VisitableBuilder<? extends LocalObjectReference,?> pushSecret;
    private VisitableBuilder<? extends ObjectReference,?> to;

    public BuildOutputFluentImpl(){
    }
    public BuildOutputFluentImpl(BuildOutput instance){
            this.withPushSecret(instance.getPushSecret()); 
            this.withTo(instance.getTo()); 
    }

    public LocalObjectReference getPushSecret(){
            return this.pushSecret!=null?this.pushSecret.build():null;
    }

    public A withPushSecret(LocalObjectReference pushSecret){
            _visitables.remove(this.pushSecret);
            if (pushSecret!=null){ this.pushSecret= new LocalObjectReferenceBuilder(pushSecret); _visitables.add(this.pushSecret);} return (A) this;
    }

    public BuildOutputFluent.PushSecretNested<A> withNewPushSecret(){
            return new PushSecretNestedImpl();
    }

    public BuildOutputFluent.PushSecretNested<A> withNewPushSecretLike(LocalObjectReference item){
            return new PushSecretNestedImpl(item);
    }

    public BuildOutputFluent.PushSecretNested<A> editPushSecret(){
            return withNewPushSecretLike(getPushSecret());
    }

    public BuildOutputFluent.PushSecretNested<A> editOrNewPushSecret(){
            return withNewPushSecretLike(getPushSecret() != null ? getPushSecret(): new LocalObjectReferenceBuilder().build());
    }

    public BuildOutputFluent.PushSecretNested<A> editOrNewPushSecretLike(LocalObjectReference item){
            return withNewPushSecretLike(getPushSecret() != null ? getPushSecret(): item);
    }

    public A withNewPushSecret(String name){
            return (A)withPushSecret(new LocalObjectReference(name));
    }

    public ObjectReference getTo(){
            return this.to!=null?this.to.build():null;
    }

    public A withTo(ObjectReference to){
            _visitables.remove(this.to);
            if (to!=null){ this.to= new ObjectReferenceBuilder(to); _visitables.add(this.to);} return (A) this;
    }

    public BuildOutputFluent.ToNested<A> withNewTo(){
            return new ToNestedImpl();
    }

    public BuildOutputFluent.ToNested<A> withNewToLike(ObjectReference item){
            return new ToNestedImpl(item);
    }

    public BuildOutputFluent.ToNested<A> editTo(){
            return withNewToLike(getTo());
    }

    public BuildOutputFluent.ToNested<A> editOrNewTo(){
            return withNewToLike(getTo() != null ? getTo(): new ObjectReferenceBuilder().build());
    }

    public BuildOutputFluent.ToNested<A> editOrNewToLike(ObjectReference item){
            return withNewToLike(getTo() != null ? getTo(): item);
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildOutputFluentImpl that = (BuildOutputFluentImpl) o;
            if (pushSecret != null ? !pushSecret.equals(that.pushSecret) :that.pushSecret != null) return false;
            if (to != null ? !to.equals(that.to) :that.to != null) return false;
            return true;
    }


    public class PushSecretNestedImpl<N> extends LocalObjectReferenceFluentImpl<BuildOutputFluent.PushSecretNested<N>> implements BuildOutputFluent.PushSecretNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final LocalObjectReferenceBuilder builder;
    
            PushSecretNestedImpl(LocalObjectReference item){
                    this.builder = new LocalObjectReferenceBuilder(this, item);
            }
            PushSecretNestedImpl(){
                    this.builder = new LocalObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) BuildOutputFluentImpl.this.withPushSecret(builder.build());
    }
    public N endPushSecret(){
            return and();
    }

}
    public class ToNestedImpl<N> extends ObjectReferenceFluentImpl<BuildOutputFluent.ToNested<N>> implements BuildOutputFluent.ToNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{

            private final ObjectReferenceBuilder builder;
    
            ToNestedImpl(ObjectReference item){
                    this.builder = new ObjectReferenceBuilder(this, item);
            }
            ToNestedImpl(){
                    this.builder = new ObjectReferenceBuilder(this);
            }
    
    public N and(){
            return (N) BuildOutputFluentImpl.this.withTo(builder.build());
    }
    public N endTo(){
            return and();
    }

}


}
