package io.fabric8.openshift.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.validators.CheckObjectMeta;
import java.lang.String;
import io.fabric8.kubernetes.api.model.EnvVarBuilder;
import javax.validation.constraints.NotNull;
import io.fabric8.kubernetes.api.model.ObjectMetaFluent;
import io.fabric8.kubernetes.api.model.ObjectReference;
import io.fabric8.kubernetes.api.model.EnvVar;
import java.util.List;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.sundr.builder.annotations.Buildable;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import javax.annotation.Generated;
import io.fabric8.kubernetes.api.model.EnvVarFluent;
import io.fabric8.kubernetes.api.builder.Fluent;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import io.fabric8.kubernetes.api.model.ObjectReferenceFluent;
import javax.validation.Valid;
import io.fabric8.kubernetes.api.model.ObjectReferenceBuilder;
import java.lang.Long;
import java.lang.Object;
import lombok.ToString;
import java.util.Map;

public interface BuildRequestFluent<A extends BuildRequestFluent<A>> extends Fluent<A>{


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public BinaryBuildSource getBinary();
    public A withBinary(BinaryBuildSource binary);
    public BuildRequestFluent.BinaryNested<A> withNewBinary();
    public BuildRequestFluent.BinaryNested<A> withNewBinaryLike(BinaryBuildSource item);
    public BuildRequestFluent.BinaryNested<A> editBinary();
    public BuildRequestFluent.BinaryNested<A> editOrNewBinary();
    public BuildRequestFluent.BinaryNested<A> editOrNewBinaryLike(BinaryBuildSource item);
    public A withNewBinary(String asFile);
    public A addToEnv(EnvVar... items);
    public A removeFromEnv(EnvVar... items);
    public List<EnvVar> getEnv();
    public A withEnv(List<EnvVar> env);
    public A withEnv(EnvVar... env);
    public BuildRequestFluent.EnvNested<A> addNewEnv();
    public BuildRequestFluent.EnvNested<A> addNewEnvLike(EnvVar item);
    public ObjectReference getFrom();
    public A withFrom(ObjectReference from);
    public BuildRequestFluent.FromNested<A> withNewFrom();
    public BuildRequestFluent.FromNested<A> withNewFromLike(ObjectReference item);
    public BuildRequestFluent.FromNested<A> editFrom();
    public BuildRequestFluent.FromNested<A> editOrNewFrom();
    public BuildRequestFluent.FromNested<A> editOrNewFromLike(ObjectReference item);
    public String getKind();
    public A withKind(String kind);
    public Long getLastVersion();
    public A withLastVersion(Long lastVersion);
    public ObjectMeta getMetadata();
    public A withMetadata(ObjectMeta metadata);
    public BuildRequestFluent.MetadataNested<A> withNewMetadata();
    public BuildRequestFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item);
    public BuildRequestFluent.MetadataNested<A> editMetadata();
    public BuildRequestFluent.MetadataNested<A> editOrNewMetadata();
    public BuildRequestFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item);
    public SourceRevision getRevision();
    public A withRevision(SourceRevision revision);
    public BuildRequestFluent.RevisionNested<A> withNewRevision();
    public BuildRequestFluent.RevisionNested<A> withNewRevisionLike(SourceRevision item);
    public BuildRequestFluent.RevisionNested<A> editRevision();
    public BuildRequestFluent.RevisionNested<A> editOrNewRevision();
    public BuildRequestFluent.RevisionNested<A> editOrNewRevisionLike(SourceRevision item);
    public A addToTriggeredBy(BuildTriggerCause... items);
    public A removeFromTriggeredBy(BuildTriggerCause... items);
    public List<BuildTriggerCause> getTriggeredBy();
    public A withTriggeredBy(List<BuildTriggerCause> triggeredBy);
    public A withTriggeredBy(BuildTriggerCause... triggeredBy);
    public BuildRequestFluent.TriggeredByNested<A> addNewTriggeredBy();
    public BuildRequestFluent.TriggeredByNested<A> addNewTriggeredByLike(BuildTriggerCause item);
    public ObjectReference getTriggeredByImage();
    public A withTriggeredByImage(ObjectReference triggeredByImage);
    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImage();
    public BuildRequestFluent.TriggeredByImageNested<A> withNewTriggeredByImageLike(ObjectReference item);
    public BuildRequestFluent.TriggeredByImageNested<A> editTriggeredByImage();
    public BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImage();
    public BuildRequestFluent.TriggeredByImageNested<A> editOrNewTriggeredByImageLike(ObjectReference item);

    public interface BinaryNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BinaryBuildSourceFluent<BuildRequestFluent.BinaryNested<N>>{

        
    public N and();    public N endBinary();
}
    public interface EnvNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,EnvVarFluent<BuildRequestFluent.EnvNested<N>>{

        
    public N and();    public N endEnv();
}
    public interface FromNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<BuildRequestFluent.FromNested<N>>{

        
    public N and();    public N endFrom();
}
    public interface MetadataNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectMetaFluent<BuildRequestFluent.MetadataNested<N>>{

        
    public N and();    public N endMetadata();
}
    public interface RevisionNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,SourceRevisionFluent<BuildRequestFluent.RevisionNested<N>>{

        
    public N and();    public N endRevision();
}
    public interface TriggeredByNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,BuildTriggerCauseFluent<BuildRequestFluent.TriggeredByNested<N>>{

        
    public N and();    public N endTriggeredBy();
}
    public interface TriggeredByImageNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,ObjectReferenceFluent<BuildRequestFluent.TriggeredByImageNested<N>>{

        
    public N and();    public N endTriggeredByImage();
}


}
