package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import javax.annotation.Generated;
import lombok.EqualsAndHashCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.lang.Boolean;
import lombok.ToString;
import io.sundr.builder.annotations.Buildable;

public class BuildStrategyBuilder extends BuildStrategyFluentImpl<BuildStrategyBuilder> implements VisitableBuilder<BuildStrategy,BuildStrategyBuilder>{

    BuildStrategyFluent<?> fluent;
    Boolean validationEnabled;

    public BuildStrategyBuilder(){
            this(true);
    }
    public BuildStrategyBuilder(Boolean validationEnabled){
            this(new BuildStrategy(), validationEnabled);
    }
    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent){
            this(fluent, true);
    }
    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new BuildStrategy(), validationEnabled);
    }
    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent,BuildStrategy instance){
            this(fluent, instance, true);
    }
    public BuildStrategyBuilder(BuildStrategyFluent<?> fluent,BuildStrategy instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withCustomStrategy(instance.getCustomStrategy()); 
            fluent.withDockerStrategy(instance.getDockerStrategy()); 
            fluent.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy()); 
            fluent.withSourceStrategy(instance.getSourceStrategy()); 
            fluent.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }
    public BuildStrategyBuilder(BuildStrategy instance){
            this(instance,true);
    }
    public BuildStrategyBuilder(BuildStrategy instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withCustomStrategy(instance.getCustomStrategy()); 
            this.withDockerStrategy(instance.getDockerStrategy()); 
            this.withJenkinsPipelineStrategy(instance.getJenkinsPipelineStrategy()); 
            this.withSourceStrategy(instance.getSourceStrategy()); 
            this.withType(instance.getType()); 
            this.validationEnabled = validationEnabled; 
    }

    public BuildStrategy build(){
            BuildStrategy buildable = new BuildStrategy(fluent.getCustomStrategy(),fluent.getDockerStrategy(),fluent.getJenkinsPipelineStrategy(),fluent.getSourceStrategy(),fluent.getType());
            io.fabric8.kubernetes.api.builder.ValidationUtils.validate(buildable);
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            BuildStrategyBuilder that = (BuildStrategyBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
